/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.ConnectedBodies;

import BryceImages.ColorCalculators.RayMarching.BryceMath;
import Game_Engine.Engine.Objs.Obj;

public abstract class obj_body
extends Obj {
    protected obj_body parent;
    protected double max_deviation_from_parent = 360.0;
    protected double gravity_angle_step = 0.0;
    public static double gravity_dir = 270.0;
    protected double parent_distance;
    protected double parent_angle;
    public double myAngle = 0.0;
    public double myAngleStart;

    public obj_body(double x, double y, double relative_angle) {
        super(x, y);
        this.load_sprite();
        this.parent_distance = BryceMath.distance(0.0, 0.0, x, y);
        this.parent_angle = BryceMath.lineAngle(x, y, 0.0, 0.0);
        this.myAngleStart = relative_angle;
    }

    protected abstract void load_sprite();

    protected abstract void logic_update();

    @Override
    public void update() {
        this.logic_update();
        this.sprite_angle = this.myAngle;
        if (!this.isRoot()) {
            this.parent.ensureUpdate();
            double offsetAngle = this.parent.sprite_angle + this.parent_angle;
            double x = this.parent.getX() + this.parent_distance * Math.cos(Math.toRadians(offsetAngle));
            double y = this.parent.getY() - this.parent_distance * Math.sin(Math.toRadians(offsetAngle));
            this.sprite_angle += this.myAngleStart + offsetAngle;
            this.setX(x);
            this.setY(y);
        }
        this.handle_gravity();
        this.handle_restraints();
    }

    private void handle_gravity() {
        if (this.gravity_angle_step <= 0.0) {
            return;
        }
        if (-90.0 < this.sprite_angle && this.sprite_angle <= 90.0) {
            this.sprite_angle = Math.max(-90.0, this.sprite_angle -= this.gravity_angle_step);
            return;
        }
        if (90.0 < this.sprite_angle && this.sprite_angle < 270.0) {
            this.sprite_angle = Math.min(270.0, this.sprite_angle += this.gravity_angle_step);
            return;
        }
    }

    private void handle_restraints() {
        this.myAngle %= 360.0;
        if (this.isRoot()) {
            return;
        }
        this.parent.sprite_angle %= 360.0;
        double angle_diff = this.myAngle - this.parent.sprite_angle;
        if (angle_diff > 180.0) {
            angle_diff -= 360.0;
        }
        if (angle_diff < -180.0) {
            angle_diff += 360.0;
        }
        if (angle_diff > this.max_deviation_from_parent) {
            this.sprite_angle = this.parent.sprite_angle + this.max_deviation_from_parent;
            this.myAngle = this.max_deviation_from_parent;
            return;
        }
        if (angle_diff < -this.max_deviation_from_parent) {
            this.sprite_angle = this.parent.sprite_angle - this.max_deviation_from_parent;
            this.myAngle = -this.max_deviation_from_parent;
            return;
        }
    }

    protected boolean isRoot() {
        return this.parent == null;
    }

    public void addChild(obj_body obj) {
        obj.parent = this;
    }

    public void setParent(obj_body obj) {
        this.parent = obj;
    }

    public void makeRoot() {
        this.parent = null;
    }

    public void setAngle(double angle) {
        this.myAngle = angle % 360.0;
    }
}

